; ***********************************************************************
; *  	*Tastenabfrage Inkrement oder Dekrement Register PB am
; * Name lampx.ASM, 10.2.06  PORTB ausgeben fuer R-2R Netzwerk AD7111    *
; ***********************************************************************

	#INCLUDE "P16F84.INC"	;
	__CONFIG  _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC

TAST	EQU	0CH	; 
PB	EQU	0DH	; LED 0 - 7
K1	EQU	D'128'	; Konstante K1 196
K2	EQu	D'60'	; Konstante K2 150
K3	EQU	D'1'	; Konstante K3 5
F1	EQU	0EH	; Zhlvariable F1
F2	EQU	0FH	; Zhlvariable F2
F3	EQU	10H	; Zhlvariable F3
        ORG	0
	BSF	STATUS,RP0	; Auf Registerbank 1 umschalten
	MOVLW	18H		; RA3 - RA4 Eingang der Rest Ausgang
	MOVWF	TRISA
	MOVLW	0
	MOVWF	TRISB		; Port B als Ausgabeport schalten	  
	BCF	STATUS,RP0	; Auf Registerbank 0 schalten
	MOVLW	5AH		; LED0 - LED7 setzen Bitmuster im Einschaltzustand ins w-Register
ANF0	MOVWF	PB		; Vom w-Register in Speicherzelle PB
	MOVF	PB,w
	MOVWF	PORTB		; Bitmuster fr R-2R Netzwerk				 		
	BCF	PORTA,0		; Chipselect freigeben 
	BCF	PORTA,1		; WRE NICHT fr kurze Zeit aktivieren
	CALL	ZEIT		; Unterprogramm ZEIT aufrufen
ANF	MOVF	PORTA,w		; Taster einlesen und zum w-Register bergeben	
	MOVWF	TAST		; w-Register in die Adresse 0CH mit dem Bezeichner TAST kopieren.	
	CALL	ZEIT		; Unterprogrammaufruf Zeitschleife
	BSF	PORTA,1		; Bit des Registers PORTA (WRE NICHT) wieder sperren (Resetzustand)
				; Erst nach Tasterbettigung wieder freigeben
	BTFSC	TAST,4		; bergehe nachfolgenden Befehl wenn Taster bettigt und Bit=0 
	GOTO	INT1		; sonst Sprung zu Abfrage Taster 3 INT1.(Am Taster liegt in
				; Ruhestellung eine 1)
	
	CLRF	TAST		; Lsche die Speicherzelle TAST	
	
	MOVF	PB,w		; PB nach W
	
	MOVWF	PORTB		; und nach PORTB
	BCF	PORTA,1		; Lsche Bit 1 des Registers PORTA
	
	CALL	ZEIT		; Unterprogrammaufruf
	BSF	PORTA,1		; Setze Bit 1 des Registers PORTA 
	
	INCF	PB,f		; Erhhe den Wert aus der Speicherzelle PB um 1. Flags Z
	
	MOVLW	0FFH		; Lade Konstante FF in das w-Register
	ANDWF	PB,f		; UND Verknpfung mit der Konstanten FF und  PB
	
	BTFSC	STATUS,Z	; Teste das Bit Z (Zero) im Register STATUS			  
	GOTO	ANF0		; bergehe diesen Befehl wenn Bit=0. Nur wenn das Bit gesetzt ist
				; fhre diesen Befehl aus.
	
				; sc - skip if clear. Mache beim bernchsten weiter	
INT1	MOVF	PORTA,w		; Taster einlesen und im w-Register speichern
	
	MOVWF	TAST		; w- Register in Fileregister TAST bertragen	
	
	BTFSS	TAST,3		; In Ruhestellung liegt eine 0 an Tast 3 es wird der
				; nchsten Befehl ausgefhrt Rcksprung zu ANF 
				; Wird der Taster bettigt (es liegt eine 1 an) findet das
				; Programm seine Fortsetzung mit dem bernchsten Befehl.
	GOTO  	INT3		; 
	CLRF	TAST		; bernchster Befehl: Registerinhalt von TAST lschen
	
	MOVF	PB,w		; Registerinhalt nach w- Kopieren
	
	MOVWF	PORTB		; An PORTB ausgeben
	BCF	PORTA,1		; Bit 1 des Registers PORTA auf 0 setzen
	
	CALL 	ZEIT		; Unterprogrammaufruf ZEIT
	BSF	PORTA,1		; Bit 1 der Speicherzelle PORTA setzen
				; Wird kein Taster bettigt WR/  PB bernahme gesperrt
				; Strungsunabhngiger die Datenbernahme erfolgt bei pos. Flanke von WR/
					
	DECFSZ	PB,f		; verringere den Wert aus der Speicherzelle f um 1. Falls das
				; 0 ergibt, dann ignoriere den nachfolgenden Befehl. Es wird
				; mit dem bernchsten weitergemacht.

INT3	GOTO	ANF
		
	GOTO	ANF0
	
ZEIT	MOVLW	K1		; F1 mit K1 laden
	MOVWF	F1
M1	MOVLW	K2		; F2 mit K2 laden
	MOVWF	F2
M2	MOVLW	K3		; F3 mit K3 laden
	MOVWF	F3
M3	DECFSZ	F3,f		; F3 - 1, Sprung, wenn F3 = 0
	GOTO	M3		
	DECFSZ	F2,f		; F2 - 1, Sprung, wenn F2 = 0
	GOTO	M2
	DECFSZ	F1,f		; F1 - 1, Sprung, wenn F1 = 0
	GOTO	M1

	RETURN	

	END			; Programmende


